/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.entities;

import com.badlogic.gdx.math.Vector2;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import technology.rocketjump.undermount.assets.entities.model.AttachmentDescriptor;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.assets.entities.model.EntityChildAssetDescriptor;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.AttachedEntity;
import technology.rocketjump.undermount.rendering.entities.EntityPartRenderStep;

public class EntityRenderSteps {
    private final TreeMap<Integer, EntityPartRenderStep> partsToRender;
    private final HashMap<EntityAssetType, AttachmentDescriptor> attachmentPoints;
    private final HashMap<EntityAssetType, Entity> attachedEntities;

    public EntityRenderSteps clone() {
        return new EntityRenderSteps((TreeMap)this.partsToRender.clone(), (HashMap)this.attachmentPoints.clone(), (HashMap)this.attachedEntities.clone());
    }

    public EntityRenderSteps(TreeMap<Integer, EntityPartRenderStep> partsToRender, HashMap<EntityAssetType, AttachmentDescriptor> attachmentPoints, HashMap<EntityAssetType, Entity> attachedEntities) {
        this.partsToRender = partsToRender;
        this.attachmentPoints = attachmentPoints;
        this.attachedEntities = attachedEntities;
    }

    public EntityRenderSteps() {
        this.partsToRender = new TreeMap();
        this.attachmentPoints = new HashMap();
        this.attachedEntities = new HashMap();
    }

    public void clear() {
        this.partsToRender.clear();
        this.attachmentPoints.clear();
        this.attachedEntities.clear();
    }

    public Collection<EntityPartRenderStep> getRenderSteps() {
        return this.partsToRender.values();
    }

    public void addPartToRender(int renderLayer, EntityPartRenderStep entityPartRenderStep) {
        this.partsToRender.put(renderLayer, entityPartRenderStep);
    }

    public void addAttachmentPoints(List<EntityChildAssetDescriptor> attachmentPointList, Vector2 parentPosition) {
        for (EntityChildAssetDescriptor attachmentPoint : attachmentPointList) {
            this.attachmentPoints.put(attachmentPoint.getType(), new AttachmentDescriptor(attachmentPoint, parentPosition));
        }
    }

    public void addAttachedEntity(AttachedEntity attachedEntity) {
        this.attachedEntities.put(attachedEntity.holdPosition.getAttachmentType(), attachedEntity.entity);
    }

    public Set<Map.Entry<EntityAssetType, Entity>> getAttachedEntities() {
        return this.attachedEntities.entrySet();
    }

    public AttachmentDescriptor getAttachmentPoint(EntityAssetType key) {
        return this.attachmentPoints.get(key);
    }
}

